/*
 * Decompiled with CFR 0.152.
 */
package net.firemuffin303.thaidelight.common.item.bottle;

import net.firemuffin303.thaidelight.common.entity.Bottleable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class MobBottleItem
extends Item {
    private final EntityType<?> entityType;
    private final SoundEvent emptySound;

    public MobBottleItem(EntityType<?> entityType, SoundEvent emptySound, Item.Properties properties) {
        super(properties);
        this.entityType = entityType;
        this.emptySound = emptySound;
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        ItemStack itemStack = useOnContext.m_43722_();
        Player user = useOnContext.m_43723_();
        BlockPos blockPos = useOnContext.m_8083_();
        Direction direction = useOnContext.m_43719_();
        BlockPos blockPos2 = blockPos.m_121955_(direction.m_122436_());
        this.checkExtraContent(user, useOnContext.m_43725_(), itemStack, blockPos2);
        user.m_21008_(useOnContext.m_43724_(), MobBottleItem.getEmptySuccessItem(itemStack, user));
        return InteractionResult.SUCCESS;
    }

    public static ItemStack getEmptySuccessItem(ItemStack itemStack, Player player) {
        return !player.m_150110_().f_35937_ ? new ItemStack((ItemLike)Items.f_42590_) : itemStack;
    }

    public void checkExtraContent(@Nullable Player player, Level level, ItemStack itemStack, BlockPos blockPos) {
        if (level instanceof ServerLevel) {
            this.spawn((ServerLevel)level, itemStack, blockPos);
            this.playEmptySound(player, (LevelAccessor)level, blockPos);
            level.m_142346_((Entity)player, GameEvent.f_157810_, blockPos);
        }
    }

    protected void playEmptySound(@Nullable Player player, LevelAccessor levelAccessor, BlockPos blockPos) {
        levelAccessor.m_5594_(player, blockPos, this.emptySound, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private void spawn(ServerLevel serverLevel, ItemStack itemStack, BlockPos blockPos) {
        Entity entity = this.entityType.m_20592_(serverLevel, itemStack, (Player)null, blockPos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof Bottleable) {
            Bottleable bottleable = (Bottleable)entity;
            bottleable.copyDataFromNbt(itemStack.m_41784_());
            bottleable.setFromBottle(true);
        }
    }
}

